<?php
/**
 * All admin facing functions
 */
namespace Codexpert\CoDesigner_Pro\App;
use Codexpert\Plugin\Base;
use Codexpert\Plugin\Metabox;
use Codexpert\CoDesigner\Helper;

/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @package Plugin
 * @subpackage Admin
 * @author Codexpert <hi@codexpert.io>
 */
class Admin extends Base {

	public $plugin;
	public $slug;
	public $name;
	public $server;
	public $version;

	/**
	 * Constructor function
	 */
	public function __construct( $plugin ) {
		$this->plugin	= $plugin;
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->server	= $this->plugin['server'];
		$this->version	= $this->plugin['Version'];
	}

	/**
	 * Internationalization
	 */
	public function i18n() {
		load_plugin_textdomain( 'codesigner-pro', false, CODESIGNER_PRO_DIR . '/languages/' );
	}

	/**
	 * Enqueue JavaScripts and stylesheets
	 */
	public function enqueue_scripts() {
		$min = defined( 'CODESIGNER_PRO_DEBUG' ) && CODESIGNER_PRO_DEBUG ? '' : '.min';
		
		wp_enqueue_style( $this->slug, plugins_url( "/assets/css/admin{$min}.css", CODESIGNER_PRO ), '', $this->version, 'all' );
		wp_enqueue_script( $this->slug, plugins_url( "/assets/js/admin{$min}.js", CODESIGNER_PRO ), [ 'jquery' ], $this->version, true );

	    $localized = [
	    	'homeurl'		=> get_bloginfo( 'url' ),
	    	'adminurl'		=> admin_url(),
	    	'asseturl'		=> CODESIGNER_PRO_ASSETS,
	    	'ajaxurl'		=> admin_url( 'admin-ajax.php' ),
	    	'_wpnonce'		=> wp_create_nonce(),
	    	'api_base'		=> get_rest_url(),
	    	'rest_nonce'	=> wp_create_nonce( 'wp_rest' ),
	    ];

	    wp_localize_script( $this->slug, 'CODESIGNER_PRO', apply_filters( "{$this->slug}-localized", $localized ) );

	}

	public function head() {
		if( get_option( "_license_{$this->slug}_migrated" ) == 1 ) {
			return;
		}

		$url = 'https://codexpert.io/dashboard/wp-json/cx-license/fetch';

		$status = $this->plugin['license']->get_license_status();

		if( $status == 'valid' ) {
			$license = $this->plugin['license']->get_license_key();
			$response = wp_remote_retrieve_body( wp_remote_get( add_query_arg( 'license', $license, $url ) ) );
			$response = json_decode( $response );

			if( false != $response->success ) {
				update_option( "_license_{$this->slug}_migrated", 1 );

				// update license meta
				$old_license_meta = get_option( "_license_{$this->slug}_meta" );
				$old_license_meta->payment_id = $response->data;

				update_option( "_license_{$this->slug}_meta", $old_license_meta );
			}
		}
	}

	public function plugin_row_meta( $plugin_meta, $plugin_file ) {
		
		if ( $this->plugin['basename'] === $plugin_file ) {
			$plugin_meta['help'] = '<a href="https://help.codexpert.io/" target="_blank" class="cx-help">' . __( 'Help', 'codesigner-pro' ) . '</a>';
		}

		return $plugin_meta;
	}

	public function update_cache( $post_id, $post, $update ) {
		wp_cache_delete( "codesigner_pro_{$post->post_type}", 'codesigner_pro' );
	}

	public function footer_text( $text ) {
		if( get_current_screen()->parent_base != $this->slug ) return $text;

		return sprintf( __( 'If you like <strong>%1$s</strong>, please <a href="%2$s" target="_blank">leave us a %3$s rating</a> on WordPress.org! It\'d motivate and inspire us to make the plugin even better!', 'codesigner-pro' ), $this->name, "https://wordpress.org/support/plugin/{$this->slug}/reviews/?filter=5#new-post", '⭐⭐⭐⭐⭐' );
	}

	public function modal() {
		echo '
		<div id="codesigner-pro-modal" style="display: none">
			<img id="codesigner-pro-modal-loader" src="' . esc_attr( CODESIGNER_PRO_ASSETS . '/img/loader.gif' ) . '" />
		</div>';
	}

	public function widget_links( $links ) {
		unset( $links['gopro'] );

		return $links;
	}

	public function supports_payment_form( $supports, $features, $ins  )	{
		if( $features == 'payment_form' && wcd_is_edit_mode() ) {
			return false;
		}

		return $supports;
	}

	public function pseudo_page_ids( $posts )	{
		$posts['home'] = __( 'Home', 'codesigner-pro' );

		return $posts;
	}

	public function attribute_color_field() {

		$product_taxonomy = [];
		if ( function_exists( 'wcd_get_taxonomies' ) ) {
			$product_taxonomy = wcd_get_taxonomies();
		}

		foreach ( $product_taxonomy as $_taxonomy => $value ) {
			add_action( "{$_taxonomy}_add_form_fields", function() {
				?>
				<div class="form-field term-color-wrap">
					<label for="tag-color">Color</label>
					<input type="color" id="wl-color" name="wl-color" value="#ff0000">
					<p>Input color if you want to use this as color taxonomy for CoDesigner Advance Search Widget.</p>
				</div>
				<?php
			} );
			add_action( "{$_taxonomy}_edit_form", function() {
				$term_id 	= sanitize_text_field( $_GET['tag_ID'] );
				$color  	= get_term_meta( $term_id, 'wl-color' ) ? get_term_meta( $term_id, 'wl-color', true ) : '#ff0000'; 
				?>
				<div class="form-field term-color-wrap">
					<label for="tag-color" style="display: inline-block;width: 215px;">Color</label>
					<input type="color" id="wl-color" name="wl-color" value="<?php esc_attr_e( $color ); ?>">
					<p style="margin-left: 27%;">Input color if you want to use this as color taxonomy for CoDesigner Advance Search Widget.</p>
				</div>
				<?php
			} );

			add_action( 'create_term', function( $term_id, $tt_id, $taxonomy ) {
				if ( isset( $_POST['wl-color'] ) ) {
					update_term_meta( $term_id,'wl-color', sanitize_text_field( $_POST['wl-color'] ) );
				}			}, 10, 3 );
			add_filter( 'wp_update_term_data', function( $data, $term_id, $taxonomy, $args  ) {
				if ( isset( $_POST['wl-color'] ) ) {
					update_term_meta( $term_id,'wl-color', sanitize_text_field( $_POST['wl-color'] ) );
				}
			} ,10,4 );
		}
	}

	// public function admin_notice(){

	// 	$time_period 		= 120; 
	// 	$is_closeed 		= get_option( 'notice_BIRTHDAY04' );	
	// 	$current_screen 	= get_current_screen()->base;		
	// 	$licence_expire 	= get_option( '_license_codesigner-pro_expiry' );
	// 	$currentTimestamp 	= time();
	// 	$timeDifference 	= $currentTimestamp - $licence_expire;
	// 	$daysDifference 	= abs( floor( $timeDifference / (24 * 60 * 60) ));	
		
	// 	if ( $current_screen == 'dashboard' && $is_closeed != 1  && $daysDifference <= $time_period ) {
			
	// 		printf(
	// 			'<div data-id="birthday-notice" class="notice notice-error is-dismissible cd-admin_notice" >
	// 				<div class="cd-notice-img">
	// 				<img src="%3$s">
	// 				</div>

	// 				<div class="cd-notice-content">
	// 					<p>%1$s</p>
	// 					<p>%5$s<a  target="_blank" href="%4$s" class="cd-admin-notice-button">Grab Now </a>
	// 					</p>
	// 					<form method="post">
	// 					%2$s 
	// 						<button class="notice-dismiss cd-notice"></button>
	// 					</form>
	// 				</div>				
	// 			</div>',
	// 			sprintf( __( 'Let\'s celebrate <strong>CoDesigner’s</strong> 4th Birthday! Enjoy <strong>40&#37;</strong> OFF on <strong>Renewal </strong>. (Your renewal date will start from your current plan\'s expiration date, so renewing now won\'t cost you any days on your current plan.) ' ),),
	// 			wp_nonce_field(),
	// 			esc_attr( CODESIGNER_PRO_ASSETS . '/img/codesigner_logo.png' ),
	// 			'https://codexpert.io/codesigner/pricing/',
	// 			'<strong>Coupon :</strong> <span class="cd-notice-pill"> BIRTHDAY04 </span>',
	// 		);			
	// 	}	
	// }
		
}